<?php
/**
 * Report Companies Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Rep_companies extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');

		$this->load->model('Batches_model');
		$this->load->model('Programs_model');
		$this->load->model('Trainees_model');
		$this->load->model('Companies_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Perusahaan';
         
 		$data['batch_data']   = $this->Batches_model->batch_header()->result();
 		$data['program_data'] = $this->Reports_model->get_program_header_select()->result();
 		$data['class_data']   = $this->Programs_model->get_data_class()->result();
 		$data['type_data']    = $this->Programs_model->get_data_type()->result();
 		$data['trainee_data'] = $this->Trainees_model->get_data()->result();
 		$data['company_data'] = $this->Companies_model->get_data()->result();
		
		if(check_roles('1') or check_roles('3')){
			$this->twiggy_display('adm/rep_companies/index', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data_detail()
	{	
		$company = $this->input->post("company");
		$program = $this->input->post("program");
		$programclass = $this->input->post("programclass");
		$programtype = $this->input->post("programtype");

		$where = [];
		if(isset($company) && $company != '')
		{
			$where['e.company_id'] = $company;
		}
		if(isset($program) && $program != '' && $program != '(Semua)')
		{
			$where['c.program_header_name'] = trim($program);
		}
        if(isset($programclass) && $programclass != '')
		{
			$where['c.program_header_class_id'] = $programclass;
        }
        if(isset($programtype) && $programtype != '')
		{
			$where['c.program_header_type_id'] = $programtype;
		}

		$this->session->set_userdata('where', $where);
		if($company == ''){
			$this->list_data();
		}else{
			$this->detail_data($where);
		}
	}

	public function get_data_program()
	{
		$company_name = $this->input->post('company_name');
		
		$where = [];
		$group_by = 'program_header_name';
		$order_by = 'program_header_name';

		if(isset($company_name) && $company_name != '' && $company_name != '(Semua)')
		{
			$where['f.company_name'] = trim($company_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}


	public function get_data_class()
	{
		$company_name = $this->input->post('company_name');
		$program_name = $this->input->post('program_name');

		$where = [];
		$group_by = 'program_class_name';
		$order_by = 'program_class_sort';

		if(isset($company_name) && $program_name != '' && $company_name != '(Semua)')
		{
			$where['f.company_name'] = trim($company_name);
		}

		if(isset($program_name) && $program_name != '' && $program_name != '(Semua)')
		{
			$where['program_header_name'] = trim($program_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}

	public function get_data_type()
	{
		$company_name = $this->input->post('company_name');
		$program_name = $this->input->post('program_name');
		$program_class_name = $this->input->post('program_class_name');

		$where = [];
		$group_by = 'program_type_name';
		$order_by = 'program_type_name';

		if(isset($company_name) && $program_name != '' && $company_name != '(Semua)')
		{
			$where['f.company_name'] = trim($company_name);
		}

		if(isset($program_name) && $program_name != '' && $program_name != '(Semua)')
		{
			$where['program_header_name'] = trim($program_name);
		}

		if(isset($program_class_name) && $program_class_name != '' && $program_class_name != '(Semua)')
		{
			$where['c.program_class_name'] = trim($program_class_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}

	public function get_data_companies()
	{
		$id = $this->input->post('id');

		$get_data = $this->Companies_model->get_data($id)->row();
		echo json_encode($get_data);
	}

	public function get_data_companies_detail()
	{
		$id = $this->input->post('id');

		$get_data = $this->Reports_model->get_companies_detail($id)->row();
		echo json_encode($get_data);
	}

	public function list_data(){
		$data  = [];
		$get_data = $this->Reports_model->get_companies_detail()->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'        => $no,
					'company'   => $get_row->company_name,
					'telephone' => $get_row->company_telephone,
					'email'     => $get_row->company_email,
					'address'   => $get_row->company_address,
					'total_trainees'  => $get_row->cnt ." Peserta",
				);
				$no++;
			}
		}

		$response = array(
			'data'   => $data,
			'status' => 'list_data'
		);
		output_json($response);
	}

	public function detail_data($where){
		$data  = [];
		$get_data = $this->Reports_model->get_companies_program_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'      => $no,
					'program' => $get_row->program_header_name,
					'class'   => $get_row->program_class_name,
					'type'    => $get_row->program_type_name,
					// 'cnt'     => $get_row->cnt ." Peserta",
				);
				$no++;
			}
		}

		$response = array(
			'data'   => $data,
			'status' => 'detail_data'
		);
		output_json($response);
	}

	public function export_excel() {
		$where = $this->session->userdata('where');

		if($where == null){
			$this->export_excel_list();
		}else{
			$this->export_excel_detail($where);
		}
	}

	public function export_excel_list() {
		$get_data = $this->Reports_model->get_companies_detail()->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('LOOP INDONESIA')
							   ->setLastModifiedBy('LOOP INDONESIA')
							   ->setTitle("PERUSAHAAN")
							   ->setSubject("PERUSAHAAN")
							   ->setDescription("PERUSAHAAN")
							   ->setKeywords("PERUSAHAAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "PERUSAHAAN");
	    $excel->getActiveSheet()->mergeCells('A1:F1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

	    // Buat header tabel pada baris ke 3
	    $excel->setActiveSheetIndex(0)->setCellValue('A3', "No");
	    $excel->setActiveSheetIndex(0)->setCellValue('B3', "Nama Perusahaan");
	    $excel->setActiveSheetIndex(0)->setCellValue('C3', "Telepon");
	    $excel->setActiveSheetIndex(0)->setCellValue('D3', "Email");
	    $excel->setActiveSheetIndex(0)->setCellValue('E3', "Alamat");
	    $excel->setActiveSheetIndex(0)->setCellValue('F3', "Jumlah");

	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F3')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 4; // Set baris pertama untuk isi tabel adalah baris ke 4
	    foreach($get_data as $row){ // Lakukan looping pada variabel row

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $row->company_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $row->company_telephone);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $row->company_email);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $row->company_address);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $row->cnt. " Peserta");

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
	    	$excel->getActiveSheet()->getStyle('A'.$numrow.':F'.$numrow)->applyFromArray($style_row);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		 }
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PERUSAHAAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PERUSAHAAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_excel_detail() {

		$where      = $this->session->userdata('where');
		$get_header = $this->Companies_model->get_data($where['e.company_id'])->row();
		$get_header_cnt   = $this->Reports_model->get_companies_detail($where['e.company_id'])->row();

		$get_data   = $this->Reports_model->get_companies_program_detail($where)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('LOOP INDONESIA')
							   ->setLastModifiedBy('LOOP INDONESIA')
							   ->setTitle("PERUSAHAAN")
							   ->setSubject("PERUSAHAAN")
							   ->setDescription("PERUSAHAAN")
							   ->setKeywords("PERUSAHAAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "PERUSAHAAN");
	    $excel->getActiveSheet()->mergeCells('A1:D1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Nama Perusahaan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$get_header->company_name);
		$excel->setActiveSheetIndex(0)->setCellValue('C3', "Alamat");
		$excel->setActiveSheetIndex(0)->setCellValue('D3', ": ".$get_header->company_address);

	    $excel->setActiveSheetIndex(0)->setCellValue('A4', "Telepon");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$get_header->company_telephone);
	    $excel->setActiveSheetIndex(0)->setCellValue('C4', "Email");
		$excel->setActiveSheetIndex(0)->setCellValue('D4', ": ".$get_header->company_email);
		
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Jumlah");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".$get_header_cnt->cnt ." Jumlah");

		$excel->setActiveSheetIndex(0)->setCellValue('A7', "No");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Program");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Jenis");
		$excel->setActiveSheetIndex(0)->setCellValue('D7', "Kategori");
		
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D7')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 8; // Set baris pertama untuk isi tabel adalah baris ke 4
	    foreach($get_data as $row){ // Lakukan looping pada variabel row

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $row->program_header_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $row->program_class_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $row->program_type_name);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
	    	$excel->getActiveSheet()->getStyle('A'.$numrow.':D'.$numrow)->applyFromArray($style_row);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		 }
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PERUSAHAAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = $get_header->company_name.'_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
